/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.BCHelper;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClassInstruction
extends Instruction {
    private int _index = 0;

    public int getClassIndex() {
        return this._index;
    }

    public void setClassIndex(int n) {
        this._index = n;
    }

    public ClassInstruction setClassName(String string) {
        this._index = this._owner.getPool().setClassName(0, BCHelper.getInternalForm(string, false));
        return this;
    }

    public String getClassName() {
        return BCHelper.getExternalForm(this._owner.getPool().getClassName(this._index), true);
    }

    public Instruction setClassType(Class clazz) {
        return this.setClassName(clazz.getName());
    }

    public Class getClassType() throws ClassNotFoundException {
        return BCHelper.classForName(this._owner.getPool().getClassName(this._index));
    }

    public int getLength() {
        return super.getLength() + 2;
    }

    public int getStackChange() {
        if (this._opcode == 187) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClassInstruction)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ClassInstruction classInstruction = (ClassInstruction)object;
        String string = this.getClassName();
        String string2 = classInstruction.getClassName();
        return string.length() == 0 || string2.length() == 0 || string.equals(string2);
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        this.setClassName(((ClassInstruction)instruction).getClassName());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this._index = dataInput.readUnsignedShort();
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._index);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterClassInstruction(this);
        bCVisitor.exitClassInstruction(this);
    }

    protected ClassInstruction(Code code, int n) {
        super(code);
        this._opcode = n;
    }
}

